<?php

use Illuminate\Database\Seeder;

class CertificateTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('certificate_templates')->insert([

            [
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
                'created_by' => 1,
                'certificate' => 'REGISTRATION FORM',
                'template' => '<table class="table table-bordered"><tbody><tr><td>Unique Id No</td><td>:</td><td><span style="color: rgb(57, 57, 57);"><b>{{reg_no}}</b></span><br></td></tr><tr><td>Student Name<br></td><td>:<br></td><td><span style="color: rgb(57, 57, 57);"><b>{{student_name}}</b></span><br></td></tr><tr><td>Father Name</td><td>:<br></td><td><span style="color: rgb(57, 57, 57);"><b>&nbsp;{{father_name}}</b></span><br></td></tr><tr><td>Mothers Name</td><td>:<br></td><td><span style="color: rgb(57, 57, 57);"><b>{{mother_name}}</b></span><br></td></tr><tr><td>Gender/Sex</td><td>:<br></td><td><span style="color: rgb(57, 57, 57);"><b>{{date_of_birth}}</b></span><br></td></tr><tr><td>Date of Birth</td><td>:<br></td><td><span style="color: rgb(57, 57, 57);"><b>{{gender}}</b></span><br></td></tr><tr><td>Address</td><td>:<br></td><td><span style="color: rgb(57, 57, 57);"><b>{{address}}</b></span><br></td></tr><tr><td>Department</td><td>:<br></td><td><span style="color: rgb(57, 57, 57);"><b>{{department}}</b></span><br></td></tr><tr><td>Program</td><td>:<br></td><td><span style="color: rgb(57, 57, 57);"><b>{{faculty}}</b></span><br></td></tr><tr><td>Faculty</td><td>:<br></td><td><span style="color: rgb(57, 57, 57);"><b>{{department}}</b></span><br></td></tr><tr><td>Duration</td><td>:<br></td><td><span style="color: rgb(57, 57, 57);"><b>{{faculty_duration}}</b></span><br></td></tr><tr><td>Session / Ad. Semester</td><td>:<br></td><td><span style="color: rgb(57, 57, 57);"><b>{{batch}}</b></span><br></td></tr><tr><td>Expiration Deadline</td><td>:<br></td><td><b>{{registration_validate}}</b><br></td></tr></tbody></table>',
                'custom_css' => '.subpage{padding: 10px;}',
                'student_photo' => 1,
                'status' => 1
            ],
            [
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
                'created_by' => 1,
                'certificate' => 'ATTENDANCE',
                'template' => '<table class="table table-bordered"> <tbody> <tr> <td>01.</td> <td style="text-align: right; ">Name of Student :&nbsp;</td> <td width="50%" style="text-align: left;"><b>{{student_name}}</b><br></td> </tr> <tr> <td>02.</td> <td style="text-align: right; ">Reg. No.&nbsp;:&nbsp;</td> <td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{reg_no}}</span><br></td> </tr> <tr> <td>03.</td> <td style="text-align: right; ">University Reg. No.&nbsp;:&nbsp;</td> <td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{university_reg}}</span><br></td> </tr> <tr> <td>04.</td> <td style="text-align: right; ">Faculty/Level&nbsp;:&nbsp;</td> <td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{faculty}}</span><br></td> </tr><tr><td>05.</td><td style="text-align: right; ">Batch :&nbsp;<br></td><td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{batch}}</span><br></td></tr> <tr> <td>06.</td> <td style="text-align: right; ">Year of Study&nbsp;:&nbsp;</td> <td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{year_of_study}}</span><br></td> </tr> <tr> <td>07.</td> <td style="text-align: right; ">Percentage of Attendance Secured&nbsp;:&nbsp;</td> <td width="50%" style="text-align: left;"><b>{{percentage_of_attendance}}%</b><br></td> </tr> </tbody></table>',
                'custom_css' => '.subpage{padding: 15px;}',
                'student_photo' => 0,
                'status' => 1
            ],
            [
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
                'created_by' => 1,
                'certificate' => 'TRANSFER_1',
                'template' => '<table class="table table-bordered"> <tbody> <tr> <td style="text-align: right;"><span style="text-align: right;">TC No. :&nbsp;</span><br></td> <td style="text-align: left;"><span style="font-weight: 700;">{{tc_num}}</span><br></td> <td rowspan="5">{{student_image}}</td> </tr> <tr> <td style="text-align: right; "><span style="text-align: right;">Faculty/Level :&nbsp;</span><br></td> <td style="text-align: left;"><span style="font-weight: 700;">{{faculty}}</span><br></td> </tr> <tr> <td style="text-align: right; "><span style="text-align: right;">Admission No./Reg.No. :</span><br></td> <td style="text-align: left;"><span style="font-weight: 700;">{{reg_no}}</span><br></td> </tr> <tr> <td style="text-align: right;"><span style="text-align: right;">University Reg. No. :</span><br></td> <td style="text-align: left;"><b>{{university_reg}}</b><br></td> </tr><tr><td style="text-align: right;">Batch. :<br></td><td style="text-align: left;"><span style="font-weight: 700;">{{batch}}</span><br></td></tr> </tbody></table><table class="table table-bordered"> <tbody> <tr> <td>01.</td> <td style="text-align: right; ">Name of Student :&nbsp;</td> <td width="50%" style="text-align: left;"><b>{{student_name}}</b><br></td> </tr> <tr> <td>02.</td> <td style="text-align: right; ">Name of Father.&nbsp;:&nbsp;</td> <td width="50%" style="text-align: left;"><b>{{parents_name}}</b><br></td> </tr> <tr> <td>03.</td> <td style="text-align: right; ">Date of Birth :&nbsp;</td> <td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{date_of_birth}}</span><br></td> </tr> <tr> <td>04.</td> <td style="text-align: right; ">Gender :&nbsp;</td> <td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{gender}}</span><br></td> </tr> <tr> <td>05.</td> <td style="text-align: right; ">Nationality :&nbsp;</td> <td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{nationality}}</span><br></td> </tr> <tr> <td>06.</td> <td style="text-align: right; ">Religion :&nbsp;</td> <td width="50%" style="text-align: left;"><b>{{religion}}</b><br></td> </tr> <tr> <td>07.</td> <td style="text-align: right; ">Community &amp; Caste :&nbsp;</td> <td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{caste}}</span><br></td> </tr> <tr> <td>08.</td> <td style="text-align: right; ">Date of Admission :&nbsp;</td> <td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{reg_date}}</span><br></td> </tr> <tr> <td>09.</td> <td style="text-align: right; ">Date of Leaving :&nbsp;</td> <td width="50%" style="text-align: left;"><b>{{date_of_leaving}}</b><br></td> </tr> <tr> <td>10.</td> <td style="text-align: right;">Class studied at the time of leaving :&nbsp;</td> <td width="50%" style="text-align: left;"><b>{{leaving_time_class}}</b><br></td> </tr> <tr> <td>11.</td> <td style="text-align: right; ">Whether qualified for promotion to higher class :&nbsp;</td> <td width="50%" style="text-align: left;"><b>{{qualified_to_promote}}</b><br></td> </tr> <tr> <td>12.</td> <td style="text-align: right; ">Whether the student has paid all Balance fees to the college :&nbsp;</td> <td width="50%" style="text-align: left;"><b>{{paid_fee_status}}</b><br></td> </tr> <tr> <td>13.</td> <td style="text-align: right; ">Conduct and Character :&nbsp;</td> <td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{character}}</span><br></td> </tr> </tbody></table>',
                'custom_css' => '.subpage{padding: 10px;}',
                'student_photo' => 0,
                'status' => 1
            ],
            [
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
                'created_by' => 1,
                'certificate' => 'TRANSFER_2',
                'template' => '<p></p><table class="table table-bordered"><tbody><tr><td><span style="text-align: right;">TC No. :&nbsp;</span><b>{{tc_num}}</b><br></td><td><span style="text-align: right;">बिद्यालय सं. / School No :&nbsp;</span><span style="font-weight: 700;">{{reg_no}}</span><br></td><td>Affiliation No. :&nbsp;<span style="font-weight: 700;">{{university_reg}}</span><br></td><td><span style="text-align: right;">Renewed upto. :&nbsp;</span><br></td><td><span style="text-align: right;">प्रवेश सं./Admission No. :&nbsp;</span><br></td></tr></tbody></table><table class="table table-bordered"> <tbody> <tr> <td>01.</td> <td style="text-align: left;">विद्यार्थीका नाम / Name of Student :&nbsp;</td> <td width="50%" style="text-align: left;"><b>{{student_name}}</b><br></td> </tr> <tr> <td>02.</td> <td style="text-align: left; " class="field_title">माताका नाम / Mother\'s Name :&nbsp;</td> <td width="50%" style="text-align: left;"><b>{{mother_name}}</b><br></td> </tr><tr><td>03.</td><td style="text-align: left; " class="field_title">पिताका नाम /Name of Father\'s / Guardian\'s Name :&nbsp;<br></td><td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{father_name}}</span><br></td></tr> <tr><td>04.</td><td style="text-align: left; " class="field_title">Date of birth(in Christain Era) according to Admission &amp; Withdrawal Register :<br></td><td width="50%" style="text-align: left;"><p><span style="background-color: transparent;">In figures:&nbsp;</span><span style="font-weight: 700;">{{date_of_birth}}</span></p><p><span style="background-color: transparent;">In words:</span></p><p><span style="font-weight: 700;">{{date_of_birth_in_word}}</span></p></td></tr><tr><td>05.</td><td style="text-align: left; " class="field_title">&nbsp;Proof for Date of Birth submitted at the time of admission :</td><td width="50%" style="text-align: left;"><b>{{dob_certificate}}</b></td></tr><tr><td>06.</td><td style="text-align: left; " class="field_title">राष्ट्रियता / Nationality :&nbsp;<br></td><td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{nationality}}</span><br></td></tr><tr><td>07.</td><td style="text-align: left; " class="field_title"><p>क्या अनु.जाति/ज.जा./पिछडा वर्गसे सम्बन्धित है</p><p>Whether the candidate belongs to Scheduled Caste or Schedule Tribe, or OBC:</p></td><td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{caste}}</span><br></td></tr><tr><td>08.</td><td style="text-align: left; " class="field_title">Date of the first admission in the School with the class :<br></td><td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{reg_date}}&nbsp; &nbsp; &nbsp;</span>Class Joined :<span style="font-weight: 700;">&nbsp;&nbsp;</span><span style="font-weight: 700;">{{join_time_class}}</span><br></td></tr><tr><td>09.</td><td style="text-align: left; " class="field_title"><p>पिछली कक्षा जिसमे विद्यार्थी अध्ययनरत था (अंकों में)</p><p>Class in which the pupil last studied (in words):</p></td><td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{leaving_time_class}}</span><br></td></tr><tr><td>10.</td><td style="text-align: left; " class="field_title"><p><span style="background-color: transparent;">पिछले विद्यालय / वोर्ड परीक्षा एवं परिमाण / School/Board Annual Examination last taken with the result:&nbsp;</span><br></p></td><td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{last_taken_exam_with_result}}</span><br></td></tr><tr><td>11.</td><td style="text-align: left; " class="field_title">क्या विद्यार्थीका परीक्षा परिणाम अनुत्तीर्ण है ? / Whether failed, if so once/twice in the same class :</td><td width="50%" style="text-align: left;"><b>{{exam_fail_status}}</b></td></tr><tr><td>12.</td><td style="text-align: left; " class="field_title">प्रस्तावित विषय / Subjects Studied:&nbsp;<br></td><td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{subject_studies}}</span><br></td></tr><tr><td>13.</td><td style="text-align: left; " class="field_title"><p>क्या उच्च कक्षा में पदोन्‍नतका अधिकारी है / Whether qualified for promotion to the next higher class :</p><p>If so, to which class:</p></td><td width="50%" style="text-align: left;"><p><span style="font-weight: 700;">{{qualified_to_promote}}</span></p><p><b>{{promoted_class}}</b><br></p></td></tr><tr><td>14.</td><td style="text-align: left; " class="field_title">विद्यालय दिवसों की कुल संख्या / Total No. of working days in the academic session :</td><td width="50%" style="text-align: left;"><p><span style="font-weight: 700;">{{school_college_open_total}}</span><br></p></td></tr><tr><td>15.</td><td style="text-align: left; " class="field_title">अन्तिम तिथि तक उपस्थितियों की कुल संख्या / Total No. of presence in the academic session :&nbsp;<br></td><td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{total_attendance}}</span><br></td></tr><tr><td>16.</td><td style="text-align: left; " class="field_title"><p>क्या विद्यार्थी ने विद्यालय की सभी देय राशि का भुगतान कर दिया है /&nbsp;&nbsp;<span style="background-color: transparent;">Month up to which the people has paid school dues :</span></p></td><td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{paid_fee_status}}</span><br></td></tr><tr><td>17.</td><td style="text-align: left; " class="field_title">क्या विद्यार्थी को कोई शुल्क रियायत प्रदान की गई थी, यदि हाँऽ तो उसकी प्रकृतीः / Any Fee concession availed of, if so, the nature of such concession :<br></td><td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{fee_concession_detail}}</span><br></td></tr><tr><td>18.</td><td style="text-align: left; " class="field_title">क्या विद्यार्थी&nbsp; एन.सी.सी. कैडेट/ स्काउट है? विवरण देः / Whether the pupil is NCC cadet / Boy scout / Girl Guide (give details):<br></td><td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{cadet_detail}}</span><br></td></tr><tr><td>19.</td><td style="text-align: left; " class="field_title"><p>Whether the school is under Govt/Minority/Independent Category :<br></p></td><td width="50%" style="text-align: left;"><b>{{school_category}}</b></td></tr><tr><td>20.</td><td style="text-align: left; " class="field_title">Games Played on extracurricular activities in which the pupil usually took part (mention achievement level therein)<br></td><td width="50%" style="text-align: left;"><b>{{extra_activity_detail}}</b></td></tr><tr><td>21.</td><td style="text-align: left; " class="field_title"><p>Date of application for certificate :</p></td><td width="50%" style="text-align: left;"><b>{{application_date}}</b><br></td></tr><tr><td>22.</td><td style="text-align: left; " class="field_title">विद्यालय विद्यार्थीके नाम काटनेकी तिथि / Date on which pupils name was struck off the rolls of the Vidyalaya :<br></td><td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{date_of_leaving}}</span><br></td></tr><tr><td>23.</td><td style="text-align: left; " class="field_title">प्रमाण-पत्र जारी करने की तिथी / Date of issue of certificate :&nbsp;<br></td><td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{date_of_issue}}</span><br></td></tr><tr><td>24.</td><td style="text-align: left; " class="field_title">कोइ अन्य टिप्पणी / Any other remarks :<br></td><td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{any_other_remark}}</span><br></td></tr>    </tbody></table><br><table class="table table-bordered" style="text-align: center; "><tbody><tr><td><p><br></p><p>_______________________</p><p><b>तैयारकर्ता / Prepared By</b></p></td><td><p><br></p><p>_______________________<br></p><p><b>जाँचकर्ता / Checked By</b></p></td><td><p><br></p><p><span style="background-color: transparent;">_______________________</span><br></p><p><b>ह. प्रधानाचार्य / कार्यालय मोहर</b></p><p><b>Sign of Principal with Official Seal</b></p></td></tr></tbody></table><p style="text-align: center; "><br></p>',
                'custom_css' => '.subpage{padding: 0px;}.field_title{width:65%;}p{margin: 0 0 0px;}tr{font-size: 10px;}',
                'student_photo' => 0,
                'status' => 1
            ],
            [
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
                'created_by' => 1,
                'certificate' => 'TRANSFER_3',
                'template' => '<table class="table table-bordered" style="text-align: right;"> <tbody> <tr> <td><span style="text-align: right;">TC No. :</span><br></td> <td style="text-align: left;"><span style="text-align: right;">&nbsp;</span><span style="font-weight: 700;">{{tc_num}}</span><br></td> <td><span style="text-align: right;">Admission No./Reg.No. :&nbsp;</span><br></td> <td style="text-align: left;"><span style="font-weight: 700;">{{reg_no}}</span><br></td> </tr> <tr> <td>&nbsp;{{national_id_1}}<span style="background-color: transparent;">&nbsp;:</span><br></td> <td style="text-align: left;"><span style="font-weight: 700; background-color: transparent;">{{national_id_2}}</span><br></td> <td>&nbsp;{{national_id_3}}<span style="background-color: transparent; text-align: right;">&nbsp;:</span><br></td> <td style="text-align: left;"> <span style="background-color: transparent; text-align: right;">&nbsp;</span><span style="font-weight: 700;"><span style="background-color: transparent;">{{national_id_4}}</span><br> </span></td> </tr> </tbody></table><table class="table table-bordered" style="text-align: right;"> <tbody> <tr> <td>01.</td> <td style="text-align: left;">Name of Pupil :&nbsp;</td> <td width="50%" style="text-align: left;"><b>{{student_name}}</b><br></td> </tr> <tr> <td>02.</td> <td style="text-align: left;" class="field_title">Father\'s / Guardian\'s Name :&nbsp;</td> <td width="50%" style="text-align: left;"><b>{{guardian_name}}</b><br></td> </tr> <tr> <td>03.</td> <td style="text-align: left;" class="field_title">Mother\'s Name :<br></td> <td width="50%" style="text-align: left;"><b>{{father_name}}</b><br></td> </tr> <tr> <td>04.</td> <td style="text-align: left;" class="field_title">Place of Birth :</td> <td width="50%" style="text-align: left;"><b>{{birth_place}}</b><br></td> </tr> <tr> <td>05.</td> <td style="text-align: left;" class="field_title">Nationality :&nbsp;<br></td> <td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{nationality}}</span><br></td> </tr> <tr> <td>06.</td> <td style="text-align: left;" class="field_title">Caste / Category</td> <td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{caste}}</span><br></td> </tr> <tr> <td>07.</td> <td style="text-align: left;" class="field_title"><p>Date of the first admission in the School with the class</p></td> <td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{reg_date}}</span><br></td> </tr> <tr> <td>08.</td> <td style="text-align: left;" class="field_title"><p>Date of birth(in Christain Era) according to Admission Register:</p></td> <td width="50%" style="text-align: left;"> <p><span style="background-color: transparent;">In figures:&nbsp;</span><span style="font-weight: 700;">{{date_of_birth}}</span></p> <p><span style="background-color: transparent;">In words:</span></p> <p><b>{{date_of_birth_in_word}}</b><br></p> </td> </tr> <tr> <td>09.</td> <td style="text-align: left;" class="field_title">Class in which the pupil last studied/studying:</td> <td width="50%" style="text-align: left;"><b>{{leaving_time_class}}</b><br></td> </tr> <tr> <td>10.</td> <td style="text-align: left;" class="field_title">School/Board Annual Examination last taken with the result:&nbsp;<br></td> <td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{last_taken_exam_with_result}}</span><br></td> </tr> <tr> <td>11.</td> <td style="text-align: left;" class="field_title">Promoted Class :&nbsp;</td> <td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{promoted_class}}</span><br></td> </tr> <tr> <td>12.</td> <td style="text-align: left;" class="field_title">General Conduct :&nbsp;</td> <td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{character}}</span><br></td> </tr> <tr> <td>13.</td> <td style="text-align: left;" class="field_title"><p>Date of application for Transfer certificate :</p></td> <td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{date_of_issue}}</span><br></td> </tr> <tr> <td>14.</td> <td style="text-align: left;" class="field_title">Date of issue of Transfer certificate :</td> <td width="50%" style="text-align: left;"><span style="font-weight: 700;">{{date_of_issue}}</span><br></td> </tr> <tr> <td>15.</td> <td style="text-align: left;" class="field_title"><p>Reason for leaving the school:</p></td> <td width="50%" style="text-align: left;"><b>{{qualified_to_promote}}</b><br></td> </tr> <tr> <td>16.</td> <td style="text-align: left;" class="field_title">Any other remarks:&nbsp;</td> <td width="50%" style="text-align: left;"><b>{{any_other_remark}}</b><br></td> </tr> </tbody></table><p></p><p></p><p style="text-align: right;"><br></p><table class="table table-bordered" style="text-align: right;"> <tbody> <tr> <td> <p><br></p> <p style="text-align: center; "><br></p> <p style="text-align: center; ">_______________________</p> <p style="text-align: center; "><b>&nbsp;Prepared By</b></p> </td> <td> <p><br></p> <p style="text-align: center; "><br></p> <p style="text-align: center; ">_______________________<br></p> <p style="text-align: center; "><b>Checked By</b></p> </td> <td> <p><br></p> <p><br></p> <p style="text-align: center; ">_______________________<br></p> <p style="text-align: center; "><b style="background-color: transparent;">Sign of Principal with Official Seal</b><br></p> </td> </tr> </tbody></table><p style="text-align: right;"><br></p>',
                'custom_css' => '.subpage{padding: 0px;}.field_title{width:60%;}p{margin: 0 0 0px;}',                'student_photo' => 0,
                'status' => 1
            ],
            [
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
                'created_by' => 1,
                'certificate' => 'NIRGAMUTARA_1',
                'template' => '<table class="table table-bordered"> <tbody> <tr> <td style="text-align: left;">01.</td><td style="text-align: left;"> Admission No </td> <td style="text-align: left;"><span style="color: rgb(57, 57, 57);"><b>{{reg_no}}</b></span><br></td> </tr> <tr> <td style="text-align: left;">02.</td><td style="text-align: left;"> Student Full Name </td> <td style="text-align: left;"><span style="color: rgb(57, 57, 57);"><b>{{student_name}}</b>&nbsp;</span><br></td> </tr> <tr> <td style="text-align: left;">03.</td><td style="text-align: left;"> Parent Full Name </td> <td style="text-align: left;"><span style="color: rgb(57, 57, 57);"><b>{{parents_name}}</b></span><br></td> </tr> <tr> <td style="text-align: left;">04.</td><td style="text-align: left;"> Cast </td> <td style="text-align: left;"><b>{{caste}}</b></td> </tr> <tr> <td style="text-align: left;">05.</td><td style="text-align: left;"> Parent Bussiness </td> <td style="text-align: left;"><b><span style="color: rgb(57, 57, 57);">{{father_occupation}} /&nbsp;</span>{{mother_occupation}}</b><br></td> </tr> <tr> <td style="text-align: left;">06.</td><td style="text-align: left;"> Mother Tongue </td> <td style="text-align: left;"><span style="color: rgb(57, 57, 57);"><b>{{mother_tongue}}</b></span><br></td> </tr> <tr> <td style="text-align: left;">07.</td><td style="text-align: left;"> Admission Date </td> <td style="text-align: left;"><span style="color: rgb(57, 57, 57);"><b>{{reg_date}}</b></span><br></td> </tr> <tr> <td style="text-align: left;">08.</td><td style="text-align: left;"> Birth Date in number </td> <td style="text-align: left;"><b>{{date_of_birth}}</b><br></td> </tr> <tr> <td style="text-align: left;">09.</td><td style="text-align: left;"> Birth Date in word </td> <td style="text-align: left;"><b>{{date_of_birth_in_word}}</b><br></td> </tr> <tr> <td style="text-align: left;">10.</td><td style="text-align: left;"> Class while admission </td> <td style="text-align: left;"><b>{{join_time_class}}</b></td> </tr><tr><td style="text-align: left;">11.</td><td style="text-align: left;">Previous School Name</td><td style="text-align: left;"><b>{{previous_school_name}}</b></td></tr><tr><td style="text-align: left;">12.</td><td style="text-align: left;">Standard</td><td style="text-align: left;"><br></td></tr><tr><td style="text-align: left;">13.</td><td style="text-align: left;">Sign of Authority</td><td style="text-align: left;"><br></td></tr><tr><td style="text-align: left;">14.</td><td style="text-align: left;">The class while leaving school</td><td style="text-align: left;"><b>{{leaving_time_class}}</b><br></td></tr><tr><td style="text-align: left;">15.</td><td style="text-align: left;">Leaving Date</td><td style="text-align: left;"><b>{{date_of_leaving}}</b></td></tr><tr><td style="text-align: left;">16.</td><td style="text-align: left;">Reason for leaving School</td><td style="text-align: left;"><b>{{reason_to_leave}}</b></td></tr><tr><td style="text-align: left;">17</td><td style="text-align: left;">Mention 2 Body Mark</td><td style="text-align: left;"><b>{{mention_body_mark}}</b></td></tr><tr><td style="text-align: left;">18.</td><td style="text-align: left;">Sign of Authority while leaving school</td><td style="text-align: left;"><br></td></tr><tr><td style="text-align: left;">19.</td><td style="text-align: left;">Head Master\'s Sign</td><td style="text-align: left;"><br></td></tr><tr><td style="text-align: left;">20.</td><td style="text-align: left;">Description</td><td style="text-align: left;"><b>{{any_other_remark}}</b></td></tr> </tbody></table><p><br></p><table class="table table-bordered"><tbody><tr><td><p>Date:</p></td><td>Place:<br></td><td style="text-align: center; "><p><br></p><p><br></p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</p><p>______________________</p><p>Seal</p></td><td style="text-align: center; "><p><br></p><p><br></p><p>______________________</p><p>Headmaster\'s Sign</p></td></tr></tbody></table><p><br></p><p><br></p>',
                'custom_css' => '.subpage{padding: 0px;}',
                'student_photo' => 0,
                'status' => 1
            ],
            [
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
                'created_by' => 1,
                'certificate' => 'NIRGAMUTARA_2',
                'template' => '<table class="table table-bordered"><tbody><tr><td>शालेचे नांवः</td><td><br></td><td>रजिस्टर नं.</td><td><br></td></tr></tbody></table><p><br></p><table class="table table-bordered"><tbody><tr><td style="text-align: left;">१</td><td style="text-align: left;">प्रवेश अनुक्रमांक&nbsp;&nbsp;</td><td style="text-align: left;"><span style="font-weight: 700; color: rgb(57, 57, 57);">{{reg_no}}</span><br></td></tr><tr><td style="text-align: left;">२</td><td style="text-align: left;">विद्यार्थ्याचे संपूर्ण नांव अडनांवासह</td><td style="text-align: left;"><span style="font-weight: 700;">{{student_name}}</span><br></td></tr><tr><td style="text-align: left;">३</td><td style="text-align: left;">आई / वडिलांचे नांव / वडील ह्यात नसल्यास पालकाये नांव</td><td style="text-align: left;"><span style="font-weight: 700; color: rgb(57, 57, 57);">{{parents_name}}</span><br></td></tr><tr><td style="text-align: left;">४</td><td style="text-align: left;">जात</td><td style="text-align: left;"><span style="font-weight: 700;">{{caste}}</span><br></td></tr><tr><td style="text-align: left;">५</td><td style="text-align: left;">वडिल पालकाचा व्यवसाय</td><td style="text-align: left;"><span style="font-weight: 700;"><span style="color: rgb(57, 57, 57);">{{father_occupation}} /&nbsp;</span>{{mother_occupation}}</span><br></td></tr><tr><td style="text-align: left;">६</td><td style="text-align: left;">मातृभाषा</td><td style="text-align: left;"><span style="font-weight: 700; color: rgb(57, 57, 57);">{{mother_tongue}}</span><br></td></tr><tr><td style="text-align: left;">७</td><td style="text-align: left;">प्रवेश दिनांक</td><td style="text-align: left;"><span style="font-weight: 700; color: rgb(57, 57, 57);">{{reg_date}}</span><br></td></tr><tr><td style="text-align: left;">८</td><td style="text-align: left;">जन्म दिनांक</td><td><p style="text-align: left;">अंकातः&nbsp;<span style="font-weight: 700; background-color: transparent;">{{date_of_birth}}</span></p><p style="text-align: left;">अक्षरातः&nbsp;<span style="font-weight: 700; background-color: transparent;">{{date_of_birth_in_word}}</span></p></td></tr><tr><td style="text-align: left;">९</td><td style="text-align: left;">प्रवेश समयीचा वर्ग</td><td style="text-align: left;"><span style="font-weight: 700;">{{join_time_class}}</span><br></td></tr><tr><td style="text-align: left;">१०</td><td style="text-align: left;">पुर्वीध्या शालेचे नांव</td><td style="text-align: left;"><span style="font-weight: 700;">{{previous_school_name}}</span><br></td></tr><tr><td style="text-align: left;">११</td><td style="text-align: left;">इयत्ता</td><td style="text-align: left;"><br></td></tr><tr><td style="text-align: left;">१२</td><td style="text-align: left;">प्रवेश देणार्‍या अधिकार्‍यांची सही</td><td style="text-align: left;"><br></td></tr><tr><td style="text-align: left;">१३</td><td style="text-align: left;">निर्गम समयी वर्ग</td><td style="text-align: left;"><span style="font-weight: 700;">{{leaving_time_class}}</span><br></td></tr><tr><td style="text-align: left;">१४</td><td style="text-align: left;">निर्गम दिनांक</td><td style="text-align: left;"><span style="font-weight: 700;">{{date_of_leaving}}</span><br></td></tr><tr><td style="text-align: left;">१५</td><td style="text-align: left;">शाला सोडण्याचे कारण</td><td style="text-align: left;"><span style="font-weight: 700;">{{reason_to_leave}}</span><br></td></tr><tr><td style="text-align: left;">१६</td><td style="text-align: left;">परिचय चिन्‍ह विद्यार्थ्याचे थोडक्यात दोन चिन्ह नाँदवावे</td><td style="text-align: left;"><span style="font-weight: 700;">{{mention_body_mark}}</span><br></td></tr><tr><td style="text-align: left;">१७</td><td style="text-align: left;">निर्गम समयी निर्गमाची नोंद घेणार्‍या अधिकारर्‍याची सही</td><td style="text-align: left;"><br></td></tr><tr><td style="text-align: left;">१८</td><td style="text-align: left;">मुख्‍याध्यापकाची स्वाक्षरी</td><td style="text-align: left;"><br></td></tr><tr><td style="text-align: left;">१९</td><td style="text-align: left;">विवरण</td><td style="text-align: left;"><span style="font-weight: 700;">{{any_other_remark}}</span><br></td></tr></tbody></table><p><br></p><p><br></p><table class="table table-bordered"><tbody><tr><td style="text-align: left;"><p>दिनांकः</p><p>स्थलः&nbsp;</p></td><td style="text-align: center; ">शालेचा शिका</td><td style="text-align: center; ">मुख्‍याध्यापकाची स्वाक्षरी</td></tr></tbody></table><p><br></p><p><br></p><p><br></p>',
                'custom_css' => '.subpage{padding: 0px;}',
                'student_photo' => 0,
                'status' => 1
            ],
            [
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
                'created_by' => 1,
                'certificate' => 'CHARACTER',
                'template' => '<p>This is to certify that&nbsp;<span style="color: rgb(57, 57, 57);"><b>{{student_name}}</b></span>&nbsp;Son of&nbsp;<span style="color: rgb(57, 57, 57);"><b>{{father_name}}</b> </span>&amp;&nbsp;<span style="color: rgb(57, 57, 57);"><b>{{mother_name}}</b></span>, Permanent Address<b>&nbsp;<span style="color: rgb(57, 57, 57);">{{address}}</span></b>, is known to me for about&nbsp;<span style="color: rgb(57, 57, 57);"><b>{{year}}</b></span>&nbsp;years. He is a citizen of&nbsp;<span style="color: rgb(57, 57, 57);"><b>{{country}}</b>&nbsp;</span>by birth.</p><p><br></p><p>To the best of my knowledge, he bears a <b>{{character}}</b> character and is not involved in such activities which are against the state freedom and peace. I wish all success and prosperity in his life.</p>',
                'custom_css' => '.subpage{padding: 15px;}',
                'student_photo' => 0,
                'status' => 1
            ],
            [
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
                'created_by' => 1,
                'certificate' => 'BONAFIDE',
                'template' => 'This is to certify that <b>{{student_name}} </b>Reg No. <b>{{reg_no}}</b>   Son of <b>{{parents_name}}</b> is a bonafide student of this College in the <b>{{course}}</b> course during the period <b>{{period}}</b>. His/Her Date of Birth as per our School/College record is <b>{{date_of_birth}}</b>.His/Her Conduct and Character are <b>{{character}}</b>.',
                'custom_css' => '.subpage{padding: 15px;}',
                'student_photo' => 0,
                'status' => 1
            ],
            [
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
                'created_by' => 1,
                'certificate' => 'COURSE COMPLETION',
                'template' => '<p>This is to certify that <b>{{student_name}}</b> Reg No. <b>{{reg_no}}</b>&nbsp; Son of <b>{{parents_name}} </b>has studied <b>{{course}}</b> in our college during the <b>{{period}}</b>. His/Her Date of Birth as per our School/College record is <b>{{date_of_birth}}</b>.His/Her Conduct and Character are <b>{{character}}</b> during the tenure of his studies.<br></p>',
                'custom_css' => '.subpage{padding: 15px;}',
                'student_photo' => 0,
                'status' => 1
            ],
            [
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
                'created_by' => 1,
                'certificate' => 'MEDIUM OF INSTRUCTION',
                'template' => '<p>This is to certify that <b>{{student_name}}</b> is a regular student of <b>{{reg_no}}</b> under the Depart of <b>{{department}}</b> of this University. It is to be mentioned that the medium of instruction and examination at this university is English.</p><p>He / She is an intelligent and hardworking student with a charming personality. To the best of my knowledge, he/she bears a good moral character.</p><p><br></p><p>I wish his / her every success in life.</p><p><br></p><p><br></p><p>(..........)</p><p>Deputy Controller of Examination(Additional Charge)</p>',
                'custom_css' => '.subpage{padding: 15px;}',
                'student_photo' => 0,
                'status' => 1
            ],
            [
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
                'created_by' => 1,
                'certificate' => 'PROVISIONAL',
                'template' => '<p style="text-align: center;"><i>This is to certify that</i></p><p style="text-align: center; "><span style="color: rgb(57, 57, 57);"><b>{{student_name}}</b></span><br></p><p style="text-align: center; "><i>Unique Student ID#</i><span style="color: rgb(57, 57, 57);"><b>{{reg_no}}</b></span></p><p style="text-align: center; "><i>has passed the examination for&nbsp;</i><span style="color: rgb(57, 57, 57); text-align: start;"><b>{{batch}}</b></span><i>&nbsp;at this university</i></p><p style="text-align: center; "><i> and obtained a degree of </i></p><p style="text-align: center; "><b>{{faculty}}</b></p><p style="text-align: center; "><i>with a cumulative GPA of</i> <b>{{gpa}}</b> <i>in a scale of</i> <b>{{scale}}</b></p><p style="text-align: center; "><i>from the</i> <b>{{department}}</b></p><p style="text-align: center; "><i>The medium of instruction of the program was English.</i></p><p style="text-align: center; "><i>In testimony where this provisional certificate is issued until such times when a</i></p><p style="text-align: center; "><i>convocation is held and a degree certificate is issued.</i></p><p style="text-align: center; "><br></p><p style="text-align: center; "><br></p><p style="text-align: center; "><br></p><p style="text-align: center; "></p><table width="90%" style="text-align: center; "> <tbody><tr> <td width="30%"> <hr> Registrar </td> <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td> <td width="40%"> <hr> Deputy Controller of Examination </td> </tr> </tbody></table><p></p><p style="text-align: center; "><br></p><p style="text-align: center; "><br></p><p style="text-align: left; "><i>Issued On:&nbsp;<span style="color: rgb(57, 57, 57);"><b>{{date_of_issue}}</b></span></i></p><p style="text-align: left; "><i>for Online Verification:</i> <b>...</b></p><p style="text-align: left; "><i>Date of Publication of Results:</i> <b>{{result_publish_date}}</b></p><p style="text-align: left; "><i>Verification Code:</i>&nbsp;<b><span style="color: rgb(57, 57, 57);">{{reg_no}}</span><span style="color: rgb(57, 57, 57);">&nbsp;</span></b></p><p><br></p><p></p>',
                'custom_css' => '.subpage{padding: 15px;}',
                'student_photo' => 0,
                'status' => 1
            ],
            [
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
                'created_by' => 1,
                'certificate' => 'TESTIMONIAL',
                'template' => '<p>This is to certify that&nbsp;<span style="font-weight: 700; color: rgb(57, 57, 57);">{{student_name}}</span>&nbsp;Son / Daughter of&nbsp;<span style="font-weight: 700;">{{father_name}}</span>&nbsp;and&nbsp;<span style="font-weight: 700;">{{mother_name}}</span>&nbsp;was a student in the Department of <b>{{department}}</b> Session&nbsp;<span style="color: rgb(57, 57, 57);"><b>{{batch}}</b></span>&nbsp;bearing Unique Student ID#<span style="font-weight: 700; color: rgb(57, 57, 57);">{{reg_no}}</span>&nbsp;under the Faculty of&nbsp;<span style="font-weight: 700;">{{department}}</span>&nbsp;at CCN University of Science and Technology. He/She has successfully completed <b>{{program_duration}}</b>&nbsp;in <b>{{year}}</b> and obtained CGPA of&nbsp;<span style="color: rgb(57, 57, 57);"><b>{{gpa}}</b>&nbsp;</span>on a scale of&nbsp;<span style="color: rgb(57, 57, 57);"><b>{{scale}}</b></span>&nbsp;with an Average Grade&nbsp;<span style="color: rgb(57, 57, 57);"><b>{{average_grade}}</b></span>. The medium of the program was English.<br></p><p><br></p><p>He/She bears a good moral character and did not participate in any activities subversive to the state or discipline of the university.</p><p><br></p><p>I wish his/her every success in life.</p><p><br></p><p><b>(Professor Dr......... )</b></p><p><b>Registrar</b></p>',
                'custom_css' => '.subpage{padding: 15px;}',
                'student_photo' => 0,
                'status' => 1
            ],
            [
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
                'created_by' => 1,
                'certificate' => 'TRANSCRIPT',
                'template' => '<table style="font-size:12px;line-height: 1.3;"><tbody><tr><td>Name of Student</td><td>:</td><td><span style="font-weight: 700; color: rgb(57, 57, 57);">&nbsp;</span><span style="font-weight: 700; color: rgb(57, 57, 57);">&nbsp;</span><span style="font-weight: 700; color: rgb(57, 57, 57);">&nbsp;</span><b style="background-color: transparent; color: rgb(57, 57, 57);">{{student_name}}</b><span style="font-weight: 700; color: rgb(57, 57, 57);"><br></span></td></tr><tr><td>Unique Student ID#</td><td>:</td><td><span style="font-weight: 700; color: rgb(57, 57, 57);">&nbsp;</span><span style="font-weight: 700; color: rgb(57, 57, 57);">&nbsp;</span><span style="font-weight: 700; color: rgb(57, 57, 57);">&nbsp;</span><b style="background-color: transparent;">{{reg_no}}</b><span style="font-weight: 700; color: rgb(57, 57, 57);"><br></span></td></tr><tr><td>Program</td><td>:</td><td><span style="font-weight: 700; color: rgb(57, 57, 57);">&nbsp;</span><span style="font-weight: 700; color: rgb(57, 57, 57);">&nbsp;</span><span style="font-weight: 700; color: rgb(57, 57, 57);">&nbsp;</span><b style="background-color: transparent;">{{faculty}}</b><span style="font-weight: 700; color: rgb(57, 57, 57);"><br></span></td></tr><tr><td>Credit Required</td><td>:</td><td><span style="font-weight: 700; color: rgb(57, 57, 57);">&nbsp;</span><span style="font-weight: 700; color: rgb(57, 57, 57);">&nbsp;</span><span style="font-weight: 700; color: rgb(57, 57, 57);">&nbsp;</span><b style="background-color: transparent; color: rgb(57, 57, 57);">{{credit_required}}</b><span style="font-weight: 700; color: rgb(57, 57, 57);"><br></span></td></tr><tr><td>Passing Year</td><td>:</td><td><span style="font-weight: 700; color: rgb(57, 57, 57);">&nbsp;</span><span style="font-weight: 700; color: rgb(57, 57, 57);">&nbsp;</span><span style="font-weight: 700; color: rgb(57, 57, 57);">&nbsp;</span><b style="background-color: transparent;">{{year}}</b><span style="font-weight: 700; color: rgb(57, 57, 57);"><br></span></td></tr><tr><td>Duration</td><td>:</td><td><span style="font-weight: 700; color: rgb(57, 57, 57);">&nbsp;</span><span style="font-weight: 700; color: rgb(57, 57, 57);">&nbsp;</span><span style="font-weight: 700; color: rgb(57, 57, 57);">&nbsp;</span><b style="background-color: transparent; color: rgb(57, 57, 57);">{{duration}}</b><span style="font-weight: 700; color: rgb(57, 57, 57);"><br></span></td></tr></tbody></table>',
                'custom_css' => '.subpage{padding: 15px;}',
                'student_photo' => 0,
                'status' => 1
            ],
            [
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
                'created_by' => 1,
                'certificate' => 'SEMESTER WISE FINAL RESULT',
                'template' => '<p>Student Name:&nbsp;<span style="color: rgb(57, 57, 57);"><b>{{student_name}}</b></span>&nbsp;Unique Student ID#<span style="color: rgb(57, 57, 57);"><b>{{reg_no}}</b></span>&nbsp;Admitted Year&nbsp;<span style="color: rgb(57, 57, 57);"><b>{{batch}}</b>&nbsp;</span>&nbsp;Passing Year&nbsp;<span style="color: rgb(57, 57, 57);"><b>{{year}}</b>&nbsp;</span>Under the Faculty of <b>{{department}}</b> got a CGPA of <b>{{gpa}}</b> and passed. Documents were submitted for permission to issue his or her Testimonial, Mark Sheet, and Provisional Certificate.</p><p>Verification Code: <b>{{verification_code}}</b></p><p>Serial Number of Mark Sheet: <b>{{mark_sheet_sn}}</b></p><p>Serial Number of Provisional Certificate: <b>{{provisional_certificate_num}}</b></p>',
                'custom_css' => '.subpage{padding: 15px;}',
                'student_photo' => 0,
                'status' => 1
            ],
            [
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
                'created_by' => 1,
                'certificate' => 'GENERAL TEMPLATE',
                'template' => '<p style="text-align: center; ">REG.NO.:<b>{{reg_no}}</b>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;REG.DATE: <b>{{reg_date}}</b></p><p style="text-align: center; "><b><br></b></p><p style="text-align: center; ">This is to certify that <b>{{student_name}}</b> son/daughter of <b>{{parents_name}}</b> Residing at <b>{{address}}</b> is bonafide Student of our school.</p><p style="text-align: center; "><br></p><p style="text-align: center; ">He/She is /was very obedient, sincere and hardworking.</p><p style="text-align: center; "><br></p><p style="text-align: center; ">He/She bears a good moral character. His/Her Date of Birth is <b>{{date_of_birth}}</b> and Place of Birth is <b>{{address}}</b>.<br></p>',
                'custom_css' => '.subpage{padding: 15px;}',
                'student_photo' => 1,
                'status' => 1
            ],
            [
            'created_at' => \Carbon\Carbon::now(),
            'updated_at' => \Carbon\Carbon::now(),
            'created_by' => 1,
            'certificate' => 'IDENTITY CARD',
            'template' => '<h5 style="text-align: center;"><b>{{student_name}}</b></h5><h6 style="text-align: center; "><b>{{faculty}}-</b><b>{{semester}}</b></h6><p></p><p><b>PARENT : {{parents_name}}</b></p><p></p><p><b>ADDRESS : {{address}}</b></p><p><b>CONTACT : {{guardian_mobile_1}}</b></p><p><b>VALID DATE : JAN 2019-  FEB 2020</b></p><p></p>',
            'custom_css' => '.subpage{padding:83px 5px 5px;color:#000!important}.page-content{padding:8px 20px 24px}h5{font-size:14px;margin:2px auto}h6{font-size:12px;margin:2px auto}.student_image{border-radius:0;width:100px;height:auto;border:2px #438eb9 solid}p{margin:1px 0 0;font-size:10px;text-align:left!important}',
            'student_photo' => 1,
            'status' => 1
            ],
            [
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
                'created_by' => 1,
                'certificate' => 'FEE VOUCHER',
                'template' => '<table class="table table-bordered"><tbody><tr><td><br><table cellspacing="0" border="0" style="width: 1027.83px; font-family: Arial; font-size: x-small;"><colgroup width="76"></colgroup><colgroup width="18"></colgroup><colgroup width="93"></colgroup><colgroup width="30"></colgroup><colgroup width="23"></colgroup><colgroup width="49"></colgroup><colgroup width="15"></colgroup><colgroup width="33"></colgroup><colgroup width="76"></colgroup><colgroup width="13"></colgroup><colgroup width="93"></colgroup><colgroup width="29"></colgroup><colgroup width="30"></colgroup><colgroup width="58"></colgroup><colgroup width="36"></colgroup><colgroup width="76"></colgroup><colgroup width="30"></colgroup><colgroup width="93"></colgroup><colgroup width="23"></colgroup><colgroup width="17"></colgroup><colgroup width="58"></colgroup><tbody><tr><td height="72" align="left" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><p><br></p></td><td colspan="6" align="center" valign="middle" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><h3><span style="font-weight: 700; font-family: " times="" new="" roman";"="">UnlimitedEduFirm&nbsp;</span></h3><h6><span style="font-weight: 700;">School &amp; College IMS</span></h6><h6><span style="font-weight: 700;">From Nepal</span></h6></td><td rowspan="29" align="center" valign="bottom"><br></td><td align="left" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td><td colspan="5" align="center" valign="middle" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><h3 style="color: rgb(0, 0, 0);"><span times="" new="" roman";"="" style="font-weight: 700;">UnlimitedEduFirm&nbsp;</span></h3><h6 style="color: rgb(0, 0, 0);"><span style="font-weight: 700;">School &amp; College IMS</span></h6><h6 style="color: rgb(0, 0, 0);"><span style="font-weight: 700;">From Nepal</span></h6></td><td rowspan="28" align="center" valign="bottom" style="border-left: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><br></td><td align="left" valign="bottom" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><br></td><td colspan="5" align="center" valign="middle" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><h3 style="color: rgb(0, 0, 0);"><span times="" new="" roman";"="" style="font-weight: 700;">UnlimitedEduFirm&nbsp;</span></h3><h6 style="color: rgb(0, 0, 0);"><span style="font-weight: 700;">School &amp; College IMS</span></h6><h6 style="color: rgb(0, 0, 0);"><span style="font-weight: 700;">From Nepal</span></h6></td></tr><tr><td colspan="7" height="48" align="center" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><p><span style="font-weight: 700;"><br>Rajbiraj, Saptari&nbsp; (Nepal)</span></p><h5 style="color: rgb(0, 0, 0);"><span style="font-weight: 700;">ACCOUNT # :&nbsp;</span>{{reg_no}}<span style="background-color: transparent; font-family: Arial; font-size: x-small;">&nbsp;</span></h5></td><td colspan="6" align="center" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><p><span style="font-weight: 700;"><br></span></p><p><span style="font-weight: 700;">Rajbiraj, Saptari&nbsp; (Nepal)</span></p><h5 style="color: rgb(0, 0, 0);"><span style="font-weight: 700;">ACCOUNT # :&nbsp;</span>{{reg_no}}<span style="background-color: transparent; font-family: Arial; font-size: x-small;">&nbsp;</span></h5></td><td colspan="6" align="center" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><p><span style="font-weight: 700;"><br></span></p><p><span style="font-weight: 700;">Rajbiraj, Saptari&nbsp; (Nepal)</span></p><h5 style="color: rgb(0, 0, 0);"><span style="font-weight: 700;">ACCOUNT # :&nbsp;</span>{{reg_no}}<span style="background-color: transparent; font-family: Arial; font-size: x-small;">&nbsp;</span></h5></td></tr><tr><td height="18" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><b>Student Name :</b></td><td colspan="6" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);">{{student_name}}</td><td align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">Student Name :</span><br></td><td colspan="5" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);">{{student_name}}<br></td><td align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><span style="font-weight: 700;">Student Name :</span><br></td><td colspan="5" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);">{{student_name}}<br></td></tr><tr><td height="18" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><b>Father Name :</b></td><td colspan="6" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);">{{father_name}}</td><td align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">Father Name :</span><br></td><td colspan="5" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);">{{father_name}}</td><td align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><span style="font-weight: 700;">Father Name :</span><br></td><td colspan="5" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);">{{father_name}}</td></tr><tr><td height="18" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">Faculty/Program/Class :</span></td><td colspan="6" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);">{{faculty}}</td><td align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">Faculty/Program/Class :</span><br></td><td colspan="5" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);">{{faculty}}</td><td align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><span style="font-weight: 700;">Faculty/Program/Class :</span><br></td><td colspan="5" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);">{{faculty}}</td></tr><tr><td height="18" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">Sec / Group :</span><br></td><td colspan="6" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);">{{semester}}</td><td align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">Sec / Group :</span><br></td><td colspan="5" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);">{{semester}}<br></td><td align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><span style="font-weight: 700;">Sec / Group :</span><br></td><td colspan="5" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);">{{semester}}<br></td></tr><tr><td height="18" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">Roll No:</span></td><td colspan="6" align="left" valign="top" sdval="4" sdnum="1033;" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="color: rgb(57, 57, 57);">{{university_reg}}</span><br></td><td align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">Roll No:</span></td><td colspan="5" align="left" valign="top" sdval="4" sdnum="1033;" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><br></td><td align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><span style="font-weight: 700;">Roll No:</span><br></td><td colspan="5" align="left" valign="top" sdval="4" sdnum="1033;" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td></tr><tr><td height="18" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">Reg No :</span></td><td colspan="6" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="color: rgb(57, 57, 57); font-family: " open="" sans";="" font-size:="" 13px;="" font-weight:="" 700;"="">{{reg_no}}</span><br></td><td align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">Reg No :</span><br></td><td colspan="5" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><br></td><td align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><span style="font-weight: 700;">Reg No :</span><br></td><td colspan="5" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td></tr><tr><td height="18" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><b>Issue Date :</b></td><td colspan="6" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);">{{date_of_issue}}</td><td align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">Issue Date :</span><br></td><td colspan="5" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><br></td><td align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><span style="font-weight: 700;">Issue Date :</span><br></td><td colspan="5" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td></tr><tr><td height="18" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">Due Date :</span><br></td><td colspan="6" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);">{{date_of_due}}</td><td align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">Due Date :</span><br></td><td colspan="5" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><br></td><td align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><span style="font-weight: 700;">Due Date :</span><br></td><td colspan="5" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td></tr><tr><td height="18" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><b>Fee Month :</b></td><td colspan="6" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);">{{month}}</td><td align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">Fee Month :</span><br></td><td colspan="5" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><br></td><td align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><span style="font-weight: 700;">Fee Month :</span><br></td><td colspan="5" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td></tr><tr><td colspan="7" height="29" align="center" valign="middle" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">FEE CHALLAN</span></td><td colspan="6" align="center" valign="middle" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><span style="font-weight: 700;">FEE CHALLAN</span></td><td colspan="6" align="center" valign="middle" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><span style="font-weight: 700;">FEE CHALLAN</span></td></tr><tr><td colspan="5" height="24" align="left" valign="middle" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">DESCRIPTION</span></td><td colspan="2" align="left" valign="middle" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">AMOUNT</span></td><td colspan="5" align="left" valign="middle" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">DESCRIPTION</span></td><td align="left" valign="middle" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><span style="font-weight: 700;">AMOUNT</span></td><td colspan="5" align="left" valign="middle" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><span style="font-weight: 700;">DESCRIPTION</span></td><td align="left" valign="middle" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">AMOUNT</span></td></tr><tr><td colspan="5" height="19" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><font size="1" color="#000000">Admission Fee :</font></td><td colspan="2" align="left" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);">{{fee}}</td><td colspan="5" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><font size="1" color="#000000">Registration Fee</font></td><td align="left" valign="bottom" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><br></td><td colspan="5" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><font size="1" color="#000000">Registration Fee</font></td><td align="left" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td></tr><tr><td colspan="5" height="18" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><font size="1" color="#000000">Security Fee :</font></td><td colspan="2" align="left" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td><td colspan="5" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><font size="1" color="#000000">Admission Fee</font></td><td align="left" valign="bottom" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><br></td><td colspan="5" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><font size="1" color="#000000">Admission Fee</font></td><td align="left" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td></tr><tr><td colspan="5" height="18" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><font size="1" color="#000000">Examination Fee :</font></td><td colspan="2" align="right" valign="top" sdval="5000" sdnum="1033;" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"></td><td colspan="5" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><font size="1" color="#000000">Tuition Fee</font></td><td align="right" valign="top" sdval="5000" sdnum="1033;" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><br></td><td colspan="5" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><font size="1" color="#000000">Tuition Fee</font></td><td align="right" valign="top" sdval="5000" sdnum="1033;" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td></tr><tr><td colspan="5" height="18" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><font size="1" color="#000000">Board Reg. Fee :</font></td><td colspan="2" align="left" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td><td colspan="5" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><font size="1" color="#000000">Board /University /Exam Fee</font></td><td align="left" valign="bottom" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><br></td><td colspan="5" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><font size="1" color="#000000">Board /University /Exam Fee</font></td><td align="left" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td></tr><tr><td colspan="5" height="18" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><font size="1" color="#000000">Misc. Funds :</font></td><td colspan="2" align="left" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td><td colspan="5" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><font size="1" color="#000000">Misc. Charges</font></td><td align="left" valign="bottom" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><br></td><td colspan="5" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><font size="1" color="#000000">Misc. Charges</font></td><td align="left" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td></tr><tr><td colspan="5" height="18" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);">Tuition Fee :</td><td colspan="2" align="left" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"></td><td colspan="5" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><font size="1" color="#000000">Re-Mid Fee</font></td><td align="left" valign="bottom" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><br></td><td colspan="5" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><font size="1" color="#000000">Re-Mid Fee</font></td><td align="left" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td></tr><tr><td colspan="5" height="18" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);">Arrear :</td><td colspan="2" align="left" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td><td colspan="5" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td><td align="left" valign="bottom" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><br></td><td colspan="5" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><br></td><td align="left" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td></tr><tr><td colspan="5" height="18" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);">Fine :&nbsp;</td><td colspan="2" align="left" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td><td colspan="5" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td><td align="left" valign="bottom" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><br></td><td colspan="5" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><br></td><td align="left" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td></tr><tr><td colspan="5" height="21" align="center" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td><td colspan="2" align="center" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td><td colspan="5" align="center" valign="bottom" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td><td align="left" valign="bottom" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><br></td><td colspan="5" align="center" valign="bottom" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><br></td><td align="left" valign="middle" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td></tr><tr><td colspan="5" height="18" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">Total Payment by date</span></td><td colspan="2" align="right" valign="top" sdval="5000" sdnum="1033;" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);">{{total}}</td><td colspan="5" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">Total Payment by date</span></td><td align="right" valign="top" sdval="5000" sdnum="1033;" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><br></td><td colspan="5" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><span style="font-weight: 700;">Total Payment by date</span></td><td align="right" valign="top" sdval="5000" sdnum="1033;" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><br></td></tr><tr><td colspan="7" height="71" align="left" valign="top" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">PAYMENT TERMS:<br>1.)&nbsp; Fee must be paid by 15th of the Month.<br>2.) Late Fee fine will be charged Rs.20/- per day.<br>3.) Arrear of the last month will be charged with Rs.300/- as fine.<br>4.) In case fee is not deposited two months, the name of the&nbsp;<br>&nbsp; &nbsp; &nbsp;student will be struck off from the college rolls automatically.<br>&nbsp; &nbsp; &nbsp;The student will have to get re-admission by paying the 50% of<br>&nbsp; &nbsp; &nbsp;admission fee.<br>&nbsp;_________________________</span></td><td colspan="6" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><span style="font-weight: 700;">PAYMENT TERMS:</span><br style="font-weight: 700;"><span style="font-weight: 700;">1.)&nbsp; Fee must be paid by 15th of the Month.</span><br style="font-weight: 700;"><span style="font-weight: 700;">2.) Late Fee fine will be charged Rs.20/- per day.</span><br style="font-weight: 700;"><span style="font-weight: 700;">3.) Arrear of the last month will be charged with Rs.300/- as fine.</span><br style="font-weight: 700;"><span style="font-weight: 700;">4.) In case fee is not deposited two months, the name of the&nbsp;</span><br style="font-weight: 700;"><span style="font-weight: 700;">&nbsp; &nbsp; &nbsp;student will be struck off from the college rolls automatically.</span><br style="font-weight: 700;"><span style="font-weight: 700;">&nbsp; &nbsp; &nbsp;The student will have to get re-admission by paying the 50% of</span><br style="font-weight: 700;"><span style="font-weight: 700;">&nbsp; &nbsp; &nbsp;admission fee.</span><br style="font-weight: 700;"><span style="font-weight: 700;">&nbsp;_________________________</span><br></td><td colspan="6" align="left" valign="top" style="border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><span style="font-weight: 700;">PAYMENT TERMS:</span><br style="font-weight: 700;"><span style="font-weight: 700;">1.)&nbsp; Fee must be paid by 15th of the Month.</span><br style="font-weight: 700;"><span style="font-weight: 700;">2.) Late Fee fine will be charged Rs.20/- per day.</span><br style="font-weight: 700;"><span style="font-weight: 700;">3.) Arrear of the last month will be charged with Rs.300/- as fine.</span><br style="font-weight: 700;"><span style="font-weight: 700;">4.) In case fee is not deposited two months, the name of the&nbsp;</span><br style="font-weight: 700;"><span style="font-weight: 700;">&nbsp; &nbsp; &nbsp;student will be struck off from the college rolls automatically.</span><br style="font-weight: 700;"><span style="font-weight: 700;">&nbsp; &nbsp; &nbsp;The student will have to get re-admission by paying the 50% of</span><br style="font-weight: 700;"><span style="font-weight: 700;">&nbsp; &nbsp; &nbsp;admission fee.</span><br style="font-weight: 700;"><span style="font-weight: 700;">&nbsp;_________________________</span><br></td></tr><tr><td colspan="7" height="20" align="right" valign="middle" style="text-align: center; border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><h6><span style="font-weight: 700;">Bank Copy</span></h6></td><td colspan="6" align="right" valign="middle" style="text-align: center; border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-left: 1px solid rgb(0, 0, 0);"><h6><span style="font-weight: 700;">College Copy</span></h6></td><td colspan="6" align="right" valign="middle" style="text-align: center; border-top: 1px solid rgb(0, 0, 0); border-bottom: 1px solid rgb(0, 0, 0); border-right: 1px solid rgb(0, 0, 0);"><h6><span style="font-weight: 700;">Student Copy</span></h6></td></tr><tr><td colspan="7" rowspan="4" height="66" align="center" valign="middle" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">BANK STAMP</span></td><td colspan="6" rowspan="4" align="center" valign="middle" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">BANK STAMP</span></td><td colspan="6" rowspan="4" align="center" valign="middle" style="border-width: 1px; border-style: solid; border-color: rgb(0, 0, 0);"><span style="font-weight: 700;">BANK STAMP</span></td></tr><tr></tr><tr></tr><tr><td align="left" valign="bottom"><br></td></tr></tbody></table></td></tr></tbody></table><p><br></p>',
                'custom_css' => '',
                'student_photo' => 1,
                'status' => 1
            ],
        ]);
    }
}

