<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateVehicleStaffsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('vehicle_staffs')) {
            Schema::create('vehicle_staffs', function (Blueprint $table) {
                $table->increments('id');
                $table->timestamps();

                $table->unsignedInteger('vehicles_id');
                $table->unsignedInteger('staffs_id');

                $table->boolean('status')->default(1);

                $table->foreign('staffs_id')->references('id')->on('staff');
                $table->foreign('vehicles_id')->references('id')->on('vehicles');
            });

        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_staffs');
    }
}
