<?php

 /*
 * Mr. Umesh Kumar Yadav
 * Business With Technology Pvt. Ltd.
 * Rupani-1 (Province 2, Saptari), Nepal
 * +977-9868156047
 * freelancerumeshnepal@gmail.com
 * https://codecanyon.net/item/unlimited-edu-firm-school-college-information-management-system/21850988
 */
namespace App\Http\Requests\Web\ContactDetail;

use Illuminate\Foundation\Http\FormRequest;

class EditValidation extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    
    public function rules()
    {
        return [
            'reg_no'                        => 'max:50 | unique:contact_directory_details,reg_no,'.decrypt($this->request->get('id')),
            'contact_directory_groups_id'    => 'required',
            'name'                          => 'required | max:100',
        ];
    }

    public function messages()
    {
        return [
            'contact_directory_groups_id.required'  =>    'Contact Group Required.'
        ];
    }
}
